<?php
/* custom range value for Customizer */
class Customizer_Touchy_Range_Value_Control extends \WP_Customize_Control {
	public $type = 'range-value';

	public function enqueue() {
		wp_enqueue_style('touchy-custom-range-control-css', $this->abs_path_to_url( dirname( __FILE__ ) . '/css/custom-range-control.css'), array(), rand() );
		wp_enqueue_script('touchy-custom-range-control-js', $this->abs_path_to_url( dirname( __FILE__ ) . '/js/custom-range-control.js'), array( 'jquery' ), rand(), true );
	}

	public function render_content() {
		?>
		<label>
			<span class="customize-control-title">
                <?php echo esc_html( $this->label ); ?>
            </span>
            <?php if ( ! empty( $this->description ) ) : ?>
			<span class="description customize-control-description">
                <?php echo $this->description; ?>
            </span>
			<?php endif; ?>
			<div class="touchy-range-slider">
				<span>
                    <input class="touchy-range-slider_range" type="range" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->input_attrs(); $this->link(); ?>>
				    <span class="touchy-range-slider_value">0</span>
                </span>
			</div>
		</label>
		<?php
	}

	private function abs_path_to_url( $path = '' ) {
		$url = str_replace(
			wp_normalize_path( untrailingslashit( ABSPATH ) ),
			site_url(),
			wp_normalize_path( $path )
		);
		return esc_url_raw( $url );
	}
} ?>